//
//  BILicenseManager.h
//  BIViews
//
//  Created by Michael Clark on 20/04/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>



typedef enum _BILicenseManagerCode {
	BILMSuccessReadingLicenseFile      = 1,
    BILMErrorReadingLicenseFile        = -1,
    BILMImproperLicenseFileFormat      = -3,
    BILMErrorWritingLicenseFile        = -4,
    BILMInvalidLicense                 = -5,
    BILMExpiredLicense                 = -6,
	BILMDemoLicense					   = -7,
	BILMBlacklistedLicense             = -8
} BILicenseManagerErrorCode;

typedef enum _BILicenseManagerStatus {
    BINoLicenseStatus                  = 0,
    BIDemoLicenseStatus                = 1,
    BIExpiredLicenseStatus             = 3,
    BINFRLicenseStatus                 = 4,
    BIValidLicenseStatus               = 5,
	BIInvalidLicenseStatus             = 6,
	BIBlacklistedLicense               = 7
} BILicenseManagerStatus;

typedef enum _BILicenseValidationReturn {
	BIValidLicenseReturn        = 1,
	BIExpiredLicenseReturn,
	BIUpgradeLicenseReturn,
	BIInvalidLicenseReturn
} BILicenseValidationReturn;

extern NSString    *BILicenseVersionKey;
extern NSString 	*BILicenseLicensesKey;
extern NSString    *BILicenseLicenseKey;
extern NSString    *BILicenseSerialKey;
extern NSString    *BILicenseFirstUseKey;

extern NSString*   BILMDateFormat;

@interface BILicenseManager : NSObject {

	BILicenseManagerStatus   _status;
	NSDictionary*            _licenseDictionary;
	
	BOOL                     _isInitialized;
	
	int                      _demoDaysSpent;
	int                      _demoDaysLeft;
	
	NSString*                _firstRunDateString;

}

+ (BILicenseManager*)defaultInstance;

- (void)validateForApplicationLaunchWithFUDString: (NSString*)fud;

- (void)registerLiceneString: (NSString*)licenseString withSerialString: (NSString*)serialString;
- (BILicenseValidationReturn)validateLicenseString: (NSString*)licenseString withSerialString: (NSString*)serialString;
- (BILicenseValidationReturn)validateLicenseString: (NSString*)licenseString withSerialString: (NSString*)serialString checkVersion: (BOOL)flag;


- (NSDictionary *)licenseDictionary;
- (void)setLicenseDictionary:(NSDictionary *)aLicenseDictionary;

- (NSString *)firstRunDateString;
- (void)setFirstRunDateString:(NSString *)aFirstRunDateString;

- (BOOL)hasValidOldLicense;

- (BILicenseManagerStatus)licenseStatus;
- (int)demoDaysSpent;
- (int)demoDaysLeft;
@end
